@CLS
@ECHO OFF
MODE CON: COLS=22 LINES=10
TITLE USB Driver Setup

CD USBDrivers
CLS

SETLOCAL
:: Detect OS version and exit if less than Windows 7
FOR /F "TOKENS=4-5 DELIMS=. " %%i IN ('VER') DO SET VERSION=%%i.%%j
IF "%VERSION%" == "10.0" GOTO WIN10
IF "%VERSION%" == "6.3" GOTO WIN8.1
IF "%VERSION%" == "6.2" GOTO WIN8
IF "%VERSION%" == "6.1" GOTO WIN7
IF "%VERSION%" LSS "6.1" GOTO NO_WIN
ENDLOCAL

:WIN11
SET OS=Windows 11
CD Windows_10_11
GOTO DONE

:WIN10
SET OS=Windows 10
CD Windows_10_11
GOTO DONE

:WIN8.1
SET OS=Windows 8.1
CD Windows_7_8.1
GOTO DONE

:WIN8
SET OS=Windows 8
CD Windows_7_8.1
GOTO DONE

:WIN7
SET OS=Windows 7
CD Windows_7_8.1
GOTO DONE

:NO_WIN
ECHO.
ECHO Operation Cancelled!
ECHO --------------------
ECHO.
ECHO USB Drivers require
ECHO Windows 7 and above.
ECHO.
ECHO Press any key...
PAUSE>NUL
EXIT

:DONE

:: Check if the OS is 32/64 bit, then search for the 32/64 bit driver and install.
IF EXIST "%PROGRAMFILES(X86)%" (SET "SEARCH=_x64") ELSE (SET "SEARCH=_x86") 
(FOR /F "DELIMS=" %%A IN ('DIR /A-D /B "%CD%" ^| FINDSTR "%SEARCH%"') DO START %%A)
EXIT
